#include <stdarg.h>
#include "lpc2214.h"

void write_dcc(volatile u32 m){
	u32 st;
	for(;;){
		asm("MRC 14,0,%0,C0,C0,0" : "=r"(st):"r"(st));
		if((st & 0x02)==0) break;
	}
	asm("MCR 14,0,%0,C1,C0,0" : : "r"(m));
}

u32 write_dcc_chk(){
	u32 st;
	asm("MRC 14,0,%0,C0,C0,0" : "=r"(st):"r"(st));
	if((st & 0x02)==0){
		return(1);
	}
	return(0);
}

void write_dcc_exec(volatile u32 m){
	asm("MCR 14,0,%0,C1,C0,0" : : "r"(m));
}

u32 read_dcc(){
	u32 m;
	for(;;){
		asm("MRC 14,0,%0,C0,C0,0" : "=r"(m):"r"(m));
		if(m & 0x01) break;
	}
	asm("MRC 14,0,%0,C1,C0,0" : "=r"(m));
	return m;
}

u32 read_dcc_chk(){
	u32 m;
	asm("MRC 14,0,%0,C0,C0,0" : "=r"(m):"r"(m));
	if(m & 0x01){
		return(1);
	}
	return(0);
}

u32 read_dcc_exec(){
	u32 m;
	asm("MRC 14,0,%0,C1,C0,0" : "=r"(m));
	return m;
}


static u32 wm=0,wi=0;

void xmit(u8 c){
	wm=(wm >> 8)+(c << 24);
	if(++wi==4){
		write_dcc(wm);
		wm=wi=0;
	}
}

void _udeci(u32 u){
	u32 div=1000000000;
	u32 flg=0;
	for(;;){
		if(u/div){
			xmit('0'+(u/div));
			flg=1;
			u-=(u/div)*div;
		}
		else if(flg || (div==1)){
			xmit('0');
		}
		div=div/10;
		if(div==0) break;
	}
}

const static s8 hexchar[16]={
'0','1','2','3','4','5','6','7',
'8','9','A','B','C','D','E','F'
};

void _hex(u32 u){
	u32 i;
	i=u>>24;
	xmit(hexchar[(i>>4)&15]);
	xmit(hexchar[i&15]);
	i=u>>16;
	xmit(hexchar[(i>>4)&15]);
	xmit(hexchar[i&15]);
	i=u>>8;
	xmit(hexchar[(i>>4)&15]);
	xmit(hexchar[i&15]);
	i=u;
	xmit(hexchar[(i>>4)&15]);
	xmit(hexchar[i&15]);
}

//	%d:POi
//	%u:ȂPOi
//	%x:PUi
//	%s:
//	%c:
//	\n:s

void print(char *fmt, ... ){
	va_list args;
	u32  i;
	s32 d;
	u32 u;
	u8  *ss;

	va_start(args,fmt);
	for(;;){
		if(*fmt=='%'){
			switch(fmt[1]){
			case 'd':		//	%d:POi
				fmt+=2;
				d=va_arg(args,int);
				if(d<0){
					xmit('-');
					u=-d;
				}
				else{
					u=d;
				}
				_udeci(u);
				break;
			case 'u':		//	%u:ȂPOi
				fmt+=2;
				u=va_arg(args,int);
				_udeci(u);
				break;
			case 'x':		//	%x:PUi
				fmt+=2;
				u=va_arg(args,int);
				_hex(u);
				break;
			case 's':		//	%s:
				fmt+=2;
				ss=va_arg(args,void *);
				for(i=0;;i++){
					if(ss[i]==0) break;
					xmit(ss[i]);
				}
				break;
			case 'c':		//	%c:
				fmt+=2;
				d=va_arg(args,int);
				xmit(d);
				break;
			default:
				xmit(*fmt);
				fmt++;
				break;
			}
		}
		else{
			if(*fmt==0) break;
			xmit(*fmt);
			fmt++;
		}
	}
	while(wi!=0){
		xmit(0);
	}
	va_end(args);
}
