#ifndef lpc2138_h
#define lpc2138_h

#define REG8  (volatile unsigned char*)
#define REG16 (volatile unsigned short*)
#define REG32 (volatile unsigned int*)

typedef unsigned char u8;
typedef signed char s8;
typedef unsigned short int u16;
typedef signed short int s16;
typedef unsigned int u32;
typedef signed int s32;

/*##############################################################################
## MISC
##############################################################################*/

#define VECTDATA_IRQ  0xE51FFFF0  /* LDR PC,[PC,#-0xFF0] */
#define VECTDATA_FIQ  /* __TODO */


/*##############################################################################
## VECTORED INTERRUPT CONTROLLER
##############################################################################*/

#define VICIRQStatus    (*(REG32 (0xFFFFF000)))
#define VICFIQStatus    (*(REG32 (0xFFFFF004)))
#define VICRawIntr      (*(REG32 (0xFFFFF008)))
#define VICIntSelect    (*(REG32 (0xFFFFF00C)))
#define VICIntEnable    (*(REG32 (0xFFFFF010)))
#define VICIntEnClear   (*(REG32 (0xFFFFF014)))
#define VICSoftInt      (*(REG32 (0xFFFFF018)))
#define VICSoftIntClear (*(REG32 (0xFFFFF01C)))
#define VICProtection   (*(REG32 (0xFFFFF020)))
#define VICVectAddr     (*(REG32 (0xFFFFF030)))
#define VICDefVectAddr  (*(REG32 (0xFFFFF034)))

#define VICVectAddr0    (*(REG32 (0xFFFFF100)))
#define VICVectAddr1    (*(REG32 (0xFFFFF104)))
#define VICVectAddr2    (*(REG32 (0xFFFFF108)))
#define VICVectAddr3    (*(REG32 (0xFFFFF10C)))
#define VICVectAddr4    (*(REG32 (0xFFFFF110)))
#define VICVectAddr5    (*(REG32 (0xFFFFF114)))
#define VICVectAddr6    (*(REG32 (0xFFFFF118)))
#define VICVectAddr7    (*(REG32 (0xFFFFF11C)))
#define VICVectAddr8    (*(REG32 (0xFFFFF120)))
#define VICVectAddr9    (*(REG32 (0xFFFFF124)))
#define VICVectAddr10   (*(REG32 (0xFFFFF128)))
#define VICVectAddr11   (*(REG32 (0xFFFFF12C)))
#define VICVectAddr12   (*(REG32 (0xFFFFF130)))
#define VICVectAddr13   (*(REG32 (0xFFFFF134)))
#define VICVectAddr14   (*(REG32 (0xFFFFF138)))
#define VICVectAddr15   (*(REG32 (0xFFFFF13C)))

#define VICVectCntl0    (*(REG32 (0xFFFFF200)))
#define VICVectCntl1    (*(REG32 (0xFFFFF204)))
#define VICVectCntl2    (*(REG32 (0xFFFFF208)))
#define VICVectCntl3    (*(REG32 (0xFFFFF20C)))
#define VICVectCntl4    (*(REG32 (0xFFFFF210)))
#define VICVectCntl5    (*(REG32 (0xFFFFF214)))
#define VICVectCntl6    (*(REG32 (0xFFFFF218)))
#define VICVectCntl7    (*(REG32 (0xFFFFF21C)))
#define VICVectCntl8    (*(REG32 (0xFFFFF220)))
#define VICVectCntl9    (*(REG32 (0xFFFFF224)))
#define VICVectCntl10   (*(REG32 (0xFFFFF228)))
#define VICVectCntl11   (*(REG32 (0xFFFFF22C)))
#define VICVectCntl12   (*(REG32 (0xFFFFF230)))
#define VICVectCntl13   (*(REG32 (0xFFFFF234)))
#define VICVectCntl14   (*(REG32 (0xFFFFF238)))
#define VICVectCntl15   (*(REG32 (0xFFFFF23C)))

#define VICIntEnClr     VICIntEnClear
#define VICSoftIntClr   VICSoftIntClear


/*##############################################################################
## Pin Connect Block
##############################################################################*/

#define PINSEL0     (*(REG32 (0xE002C000)))
#define PINSEL1     (*(REG32 (0xE002C004)))
#define PINSEL2     (*(REG32 (0xE002C014)))


/*##############################################################################
## GPIO - General Purpose I/O
##############################################################################*/

#define IOPIN      (*(REG32 (0xE0028000))) /* ALTERNATE NAME GPIO = GPIO0 */
#define IOSET      (*(REG32 (0xE0028004)))
#define IODIR      (*(REG32 (0xE0028008)))
#define IOCLR      (*(REG32 (0xE002800C)))

#define IO0PIN      (*(REG32 (0xE0028000)))
#define IO0SET      (*(REG32 (0xE0028004)))
#define IO0DIR      (*(REG32 (0xE0028008)))
#define IO0CLR      (*(REG32 (0xE002800C)))

#define IO1PIN      (*(REG32 (0xE0028010)))
#define IO1SET      (*(REG32 (0xE0028014)))
#define IO1DIR      (*(REG32 (0xE0028018)))
#define IO1CLR      (*(REG32 (0xE002801C)))

/*##############################################################################
## UART0 / UART1
##############################################################################*/

/* ---- UART 0 --------------------------------------------- */
#define U0RBR       (*(REG32 (0xE000C000)))
#define U0THR       (*(REG32 (0xE000C000)))
#define U0IER       (*(REG32 (0xE000C004)))
#define U0IIR       (*(REG32 (0xE000C008)))
#define U0FCR       (*(REG32 (0xE000C008)))
#define U0LCR       (*(REG32 (0xE000C00C)))
#define U0LSR       (*(REG32 (0xE000C014)))
#define U0SCR       (*(REG32 (0xE000C01C)))
#define U0TER       (*(REG32 (0xE000C030)))
#define U0DLL       (*(REG32 (0xE000C000)))
#define U0DLM       (*(REG32 (0xE000C004)))

/* ---- UART 1 --------------------------------------------- */
#define U1RBR       (*(REG32 (0xE0010000)))
#define U1THR       (*(REG32 (0xE0010000)))
#define U1IER       (*(REG32 (0xE0010004)))
#define U1IIR       (*(REG32 (0xE0010008)))
#define U1FCR       (*(REG32 (0xE0010008)))
#define U1LCR       (*(REG32 (0xE001000C)))
#define U1LSR       (*(REG32 (0xE0010014)))
#define U1SCR       (*(REG32 (0xE001001C)))
#define U1TER       (*(REG32 (0xE0010030)))
#define U1DLL       (*(REG32 (0xE0010000)))
#define U1DLM       (*(REG32 (0xE0010004)))
#define U1MCR       (*(REG32 (0xE0010010)))
#define U1MSR       (*(REG32 (0xE0010018)))


/*##############################################################################
## I2C
##############################################################################*/

#define I2CONSET    (*(REG32 (0xE001C000)))
#define I2STAT      (*(REG32 (0xE001C004)))
#define I2DAT       (*(REG32 (0xE001C008)))
#define I2ADR       (*(REG32 (0xE001C00C)))
#define I2SCLH      (*(REG32 (0xE001C010)))
#define I2SCLL      (*(REG32 (0xE001C014)))
#define I2CONCLR    (*(REG32 (0xE001C018)))

#define I20CONSET   (*(REG32 (0xE001C000)))
#define I20STAT     (*(REG32 (0xE001C004)))
#define I20DAT      (*(REG32 (0xE001C008)))
#define I20ADR      (*(REG32 (0xE001C00C)))
#define I20SCLH     (*(REG32 (0xE001C010)))
#define I20SCLL     (*(REG32 (0xE001C014)))
#define I20CONCLR   (*(REG32 (0xE001C018)))

#define I21CONSET   (*(REG32 (0xE005C000)))
#define I21STAT     (*(REG32 (0xE005C004)))
#define I21DAT      (*(REG32 (0xE005C008)))
#define I21ADR      (*(REG32 (0xE005C00C)))
#define I21SCLH     (*(REG32 (0xE005C010)))
#define I21SCLL     (*(REG32 (0xE005C014)))
#define I21CONCLR   (*(REG32 (0xE005C018)))


/*##############################################################################
## SPI - Serial Peripheral Interface
##############################################################################*/

#define SP0SPCR        (*(REG32 (0xE0020000)))
#define SP0SPSR        (*(REG32 (0xE0020004)))
#define SP0SPDR        (*(REG32 (0xE0020008)))
#define SP0SPCCR       (*(REG32 (0xE002000C)))
#define SP0SPINT       (*(REG32 (0xE002001C)))

#define SSPCR0         (*(REG32 (0xE0068000)))
#define SSPCR1         (*(REG32 (0xE0068004)))
#define SSPDR          (*(REG32 (0xE0068008)))
#define SSPSR          (*(REG32 (0xE006800C)))
#define SSPCPSR        (*(REG32 (0xE0068010)))
#define SSPIMSC        (*(REG32 (0xE0068014)))
#define SSPRIS         (*(REG32 (0xE0068018)))
#define SSPMIS         (*(REG32 (0xE006801C)))
#define SSPICR         (*(REG32 (0xE0068020)))


/*##############################################################################
## ADC - A/D Converter
##############################################################################*/

#define AD0CR        (*(REG32 (0xE0034000)))
#define AD0DR        (*(REG32 (0xE0034004)))
#define AD1CR        (*(REG32 (0xE0060000)))
#define AD1DR        (*(REG32 (0xE0060004)))
#define ADGSR        (*(REG32 (0xE0034008)))


/*##############################################################################
## DAC - D/A Converter
##############################################################################*/

#define DACR        (*(REG32 (0xE006C000)))


/*##############################################################################
## Timer 0 and Timer 1
##############################################################################*/

/* ---- Timer 0 -------------------------------------------- */
#define T0IR           (*(REG32 (0xE0004000)))
#define T0TCR          (*(REG32 (0xE0004004)))
#define T0TC           (*(REG32 (0xE0004008)))
#define T0PR           (*(REG32 (0xE000400C)))
#define T0PC           (*(REG32 (0xE0004010)))
#define T0MCR          (*(REG32 (0xE0004014)))
#define T0MR0          (*(REG32 (0xE0004018)))
#define T0MR1          (*(REG32 (0xE000401C)))
#define T0MR2          (*(REG32 (0xE0004020)))
#define T0MR3          (*(REG32 (0xE0004024)))
#define T0CCR          (*(REG32 (0xE0004028)))
#define T0CR0          (*(REG32 (0xE000402C)))
#define T0CR1          (*(REG32 (0xE0004030)))
#define T0CR2          (*(REG32 (0xE0004034)))
#define T0CR3          (*(REG32 (0xE0004038)))
#define T0EMR          (*(REG32 (0xE000403C)))
#define T0CTCR         (*(REG32 (0xE0004070)))

/* ---- Timer 1 -------------------------------------------- */
#define T1IR           (*(REG32 (0xE0008000)))
#define T1TCR          (*(REG32 (0xE0008004)))
#define T1TC           (*(REG32 (0xE0008008)))
#define T1PR           (*(REG32 (0xE000800C)))
#define T1PC           (*(REG32 (0xE0008010)))
#define T1MCR          (*(REG32 (0xE0008014)))
#define T1MR0          (*(REG32 (0xE0008018)))
#define T1MR1          (*(REG32 (0xE000801C)))
#define T1MR2          (*(REG32 (0xE0008020)))
#define T1MR3          (*(REG32 (0xE0008024)))
#define T1CCR          (*(REG32 (0xE0008028)))
#define T1CR0          (*(REG32 (0xE000802C)))
#define T1CR1          (*(REG32 (0xE0008030)))
#define T1CR2          (*(REG32 (0xE0008034)))
#define T1CR3          (*(REG32 (0xE0008038)))
#define T1EMR          (*(REG32 (0xE000803C)))
#define T1CTCR         (*(REG32 (0xE0008070)))


/*##############################################################################
## PWM
##############################################################################*/

#define PWMIR          (*(REG32 (0xE0014000)))
#define PWMTCR         (*(REG32 (0xE0014004)))
#define PWMTC          (*(REG32 (0xE0014008)))
#define PWMPR          (*(REG32 (0xE001400C)))
#define PWMPC          (*(REG32 (0xE0014010)))
#define PWMMCR         (*(REG32 (0xE0014014)))
#define PWMMR0         (*(REG32 (0xE0014018)))
#define PWMMR1         (*(REG32 (0xE001401C)))
#define PWMMR2         (*(REG32 (0xE0014020)))
#define PWMMR3         (*(REG32 (0xE0014024)))
#define PWMMR4         (*(REG32 (0xE0014040)))
#define PWMMR5         (*(REG32 (0xE0014044)))
#define PWMMR6         (*(REG32 (0xE0014048)))
#define PWMPCR         (*(REG32 (0xE001404C)))
#define PWMLER         (*(REG32 (0xE0014050)))

/*##############################################################################
## RTC
##############################################################################*/

/* ---- RTC: Miscellaneous Register Group ------------------ */
#define ILR         (*(REG32 (0xE0024000)))
#define CTC         (*(REG32 (0xE0024004)))
#define CCR         (*(REG32 (0xE0024008)))  
#define CIIR        (*(REG32 (0xE002400C)))
#define AMR         (*(REG32 (0xE0024010)))
#define CTIME0      (*(REG32 (0xE0024014)))
#define CTIME1      (*(REG32 (0xE0024018)))
#define CTIME2      (*(REG32 (0xE002401C)))

/* ---- RTC: Timer Control Group --------------------------- */
#define SEC         (*(REG32 (0xE0024020)))
#define MIN         (*(REG32 (0xE0024024)))
#define HOUR        (*(REG32 (0xE0024028)))
#define DOM         (*(REG32 (0xE002402C)))
#define DOW         (*(REG32 (0xE0024030)))
#define DOY         (*(REG32 (0xE0024034)))
#define MONTH       (*(REG32 (0xE0024038)))
#define YEAR        (*(REG32 (0xE002403C)))

/* ---- RTC: Alarm Control Group --------------------------- */
#define ALSEC       (*(REG32 (0xE0024060)))
#define ALMIN       (*(REG32 (0xE0024064)))
#define ALHOUR      (*(REG32 (0xE0024068)))
#define ALDOM       (*(REG32 (0xE002406C)))
#define ALDOW       (*(REG32 (0xE0024070)))
#define ALDOY       (*(REG32 (0xE0024074)))
#define ALMON       (*(REG32 (0xE0024078)))
#define ALYEAR      (*(REG32 (0xE002407C)))

/* ---- RTC: Reference Clock Divider Group ----------------- */
#define PREINT      (*(REG32 (0xE0024080)))
#define PREFRAC     (*(REG32 (0xE0024084)))


/*##############################################################################
## WD - Watchdog
##############################################################################*/

#define WDMOD        (*(REG32 (0xE0000000)))
#define WDTC         (*(REG32 (0xE0000004)))
#define WDFEED       (*(REG32 (0xE0000008)))
#define WDTV         (*(REG32 (0xE000000C)))


/*##############################################################################
## System Control Block
##############################################################################*/

#define EXTINT      (*(REG32 (0xE01FC140)))
#define EXTWAKE     (*(REG32 (0xE01FC144)))
#define EXTMODE     (*(REG32 (0xE01FC148)))
#define EXTPOLAR    (*(REG32 (0xE01FC14C)))
#define MEMMAP      (*(REG32 (0xE01FC040)))
#define PLLCON      (*(REG32 (0xE01FC080)))
#define PLLCFG      (*(REG32 (0xE01FC084)))
#define PLLSTAT     (*(REG32 (0xE01FC088)))
#define PLLFEED     (*(REG32 (0xE01FC08C)))
#define PCON        (*(REG32 (0xE01FC0C0)))
#define PCONP       (*(REG32 (0xE01FC0C4)))
#define VPBDIV      (*(REG32 (0xE01FC100)))

/*##############################################################################
## Memory Accelerator Module (MAM)
##############################################################################*/

#define MAMTIM			(*(REG32 (0xE01FC004)))
#define MAMCR			(*(REG32 (0xE01FC000)))

#endif /* lpc2138_h */

