#include "lpc2138.h"

volatile u32 timer_10ms;

#define IRQ_MASK 0x00000080

static inline unsigned asm_get_cpsr(void){
  unsigned long retval;
  asm volatile (" mrs  %0, cpsr" : "=r" (retval) : /* no inputs */  );
  return retval;
}

static inline void asm_set_cpsr(unsigned val){
  asm volatile (" msr  cpsr, %0" : /* no outputs */ : "r" (val)  );
}

u32 enable_irq(void){
  unsigned _cpsr;

  _cpsr = asm_get_cpsr();
  asm_set_cpsr(_cpsr & ~IRQ_MASK);
  return _cpsr;
}

u32 disable_irq(void){
  unsigned _cpsr;

  _cpsr = asm_get_cpsr();
  asm_set_cpsr(_cpsr | IRQ_MASK);
  return _cpsr;
}

void timer_isr (void) __attribute__ ((interrupt("IRQ")));


	//TC countup pclk/prescaler
	//pclk = cclk (defined in VPBDIV=01)
	//cclk = 58.9824MHz
	//pclk = 16.95421 nsec
	//10msec/16.95421nsec=589824
	//with prescale=1 --> TC=589824/2=294912
#define PRESCALE	1		//half
#define TICKS1MSEC	294912

void timer_isr(void){
	T0IR = 1<<0;				//write one to clear MR0 (match channel 0)
	T0TC = 0;				//clear current timer count
	
	++timer_10ms;
	//last step is to notify the end of ISR
	VICVectAddr = 0;			//dummy write to signal end of ISR
}

void timer_start(void){
	T0TCR = 0x01;				//bit 0: counter (0/1)=(stopped/started)
}

void timer_stop(void){
	T0TCR = 0x02;				//reset & disable
}

#define TC0_ID          4       /* Timer Channel 0 interrupt */

void timer_init(){
	//stop timer
	//bit 0	counter (0/1)=(stopped/started)
	//    1 reset   (0/1)=(not/do-it) when 1 counter remain till bit1=0
	T0TCR = 0x02;				//counter reset,disabled
	T0MCR &= ~0x7;				//MCR0: disable INT,reset,stop

	//vector interrupt controller
	VICIntSelect &= ~(1<<(TC0_ID));	//(RW) TC0 as IRQ group (0/1)=(IRQ/FIQ)
	VICIntEnable |= 1<<(TC0_ID);		//enable TC0 INT


	//install INT handler (highest(0) IRQ slot)
	VICVectAddr0 = timer_isr;
	VICVectCntl0 = 0x20+TC0_ID;		//bit5:1=IRQenabled, bit4-0:VIC number for slot0
	
	T0PR = PRESCALE;			//half of pclk
	T0MR0 = TICKS1MSEC;
	
	
	T0MCR |= 1;				//MCR0:enable INT (bit0)
	T0TCR = 1;				//counter not reset,started
	timer_10ms = 0;
	enable_irq();
}
